package ru.yandex.intranet.d.util;

import javax.annotation.Nullable;

import ru.yandex.intranet.d.backend.service.proto.UsageMode;
import ru.yandex.intranet.d.web.model.providers.UsageModeDto;
import ru.yandex.intranet.d.web.model.providers.UsageModeInputDto;

/**
 * Usage mode helper.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public class UsageModeHelper {

    private UsageModeHelper() {
    }

    @Nullable
    public static UsageModeInputDto fromUsageMode(
            @Nullable UsageMode mode) {
        if (mode == null) {
            return null;
        }
        return switch (mode) {
            case UNDEFINED -> UsageModeInputDto.UNDEFINED;
            case TIME_SERIES -> UsageModeInputDto.TIME_SERIES;
            case UNUSED_ESTIMATION_VALUE -> UsageModeInputDto.UNUSED_ESTIMATION_VALUE;
            default -> UsageModeInputDto.UNKNOWN;
        };
    }

    public static UsageMode toUsageMode(
            ru.yandex.intranet.d.model.providers.UsageMode mode) {
        if (mode == null) {
            return UsageMode.UNDEFINED;
        }
        return switch (mode) {
            case UNDEFINED -> UsageMode.UNDEFINED;
            case TIME_SERIES -> UsageMode.TIME_SERIES;
            case UNUSED_ESTIMATION_VALUE -> UsageMode.UNUSED_ESTIMATION_VALUE;
        };
    }

    public static ru.yandex.intranet.d.model.providers.UsageMode toUsageMode(
            UsageModeInputDto mode) {
        return switch (mode) {
            case UNDEFINED -> ru.yandex.intranet.d.model.providers.UsageMode.UNDEFINED;
            case TIME_SERIES -> ru.yandex.intranet.d.model.providers.UsageMode.TIME_SERIES;
            case UNUSED_ESTIMATION_VALUE -> ru.yandex.intranet.d.model.providers.UsageMode.UNUSED_ESTIMATION_VALUE;
            default -> throw new IllegalArgumentException("Unexpected value " + mode);
        };
    }

    public static UsageModeDto toUsageModeDto(
            ru.yandex.intranet.d.model.providers.UsageMode mode) {
        if (mode == null) {
            return UsageModeDto.UNDEFINED;
        }
        return switch (mode) {
            case UNDEFINED -> UsageModeDto.UNDEFINED;
            case TIME_SERIES -> UsageModeDto.TIME_SERIES;
            case UNUSED_ESTIMATION_VALUE -> UsageModeDto.UNUSED_ESTIMATION_VALUE;
        };
    }

    public static UsageModeInputDto toUsageModeInputDto(UsageModeDto mode) {
        return switch (mode) {
            case UNDEFINED -> UsageModeInputDto.UNDEFINED;
            case TIME_SERIES -> UsageModeInputDto.TIME_SERIES;
            case UNUSED_ESTIMATION_VALUE -> UsageModeInputDto.UNUSED_ESTIMATION_VALUE;
        };
    }

}
