package ru.yandex.intranet.d.util;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.annotation.Nullable;

/**
 * Non-specific commons.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 05-03-2021
 */
public class Util {
    private Util() {
    }

    public static boolean isEmpty(@Nullable String o) {
        return o == null || o.isEmpty();
    }

    public static boolean isEmpty(@Nullable Long o) {
        return o == null || o == 0;
    }

    public static boolean isEmpty(@Nullable Collection<?> o) {
        return o == null || o.isEmpty();
    }

    public static boolean isEmpty(@Nullable Map<?, ?> o) {
        return o == null || o.isEmpty();
    }

    public static String toString(Object o) {
        return o != null ? o.toString() : "null";
    }

    public static <T, K> Map<K, T> indexBy(Collection<T> elems, Function<T, K> keyExtractor) {
        return elems.stream()
                .collect(Collectors.toMap(keyExtractor, Function.identity()));
    }

    public static <T, K1, K2> Map<K1, Map<K2, T>> indexBy(Collection<T> elems,
                                                          Function<T, K1> keyOneExtractor,
                                                          Function<T, K2> keyTwoExtractor) {
        return elems.stream()
                .collect(Collectors.groupingBy(keyOneExtractor,
                        Collectors.toMap(keyTwoExtractor, Function.identity())));
    }

    public static boolean isAllEmpty(String... strings) {
        boolean result = true;
        for (String s: strings) {
            result = result && isEmpty(s);
        }
        return result;
    }

    @SafeVarargs
    public static <T> Stream<T> concat(Stream<T>... items) {
        return Stream.of(items).flatMap(Function.identity());
    }
}
