package ru.yandex.intranet.d.util

import org.springframework.web.util.UriComponentsBuilder

const val UTM_SOURCE = "utm_source"
const val UTM_MEDIUM = "utm_medium"
const val UTM_CAMPAIGN = "utm_campaign"

enum class UtmSource(val value: String) {
    EMAIL("email")
}

enum class UtmMedium(val value: String) {
    SINGLE_REQUEST_LINK("single_request_link")
}

enum class UtmCampaign(val value: String) {
    EMAIL_ANALYTICS("email_analytics")
}

fun addEmailUtmParams(builder: UriComponentsBuilder) {
    builder.queryParam(UTM_SOURCE, UtmSource.EMAIL.value)
    builder.queryParam(UTM_MEDIUM, UtmMedium.SINGLE_REQUEST_LINK.value)
    builder.queryParam(UTM_CAMPAIGN, UtmCampaign.EMAIL_ANALYTICS.value)
}
