package ru.yandex.intranet.d.util;

import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

import com.google.common.collect.Lists;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

import ru.yandex.intranet.d.datasource.model.YdbTxSession;

/**
 * YDB utils
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 * @since 26-02-2021
 */
public class YdbUtils {
    public static final int DEFAULT_PARTITION_SIZE = 500;

    private YdbUtils() {
    }

    public static <T, R> Mono<List<R>> getWithPartition(List<T> ids, Function<List<T>, Mono<List<R>>> mapper) {
        return getWithPartition(ids, mapper, DEFAULT_PARTITION_SIZE);
    }

    public static <T, R> Mono<List<R>> getWithPartition(List<T> ids, Function<List<T>, Mono<List<R>>> mapper,
                                                        int size) {
        return Flux.fromIterable(Lists.partition(ids, size)).concatMap(mapper).collectList()
                .map(l -> l.stream().flatMap(Collection::stream).collect(Collectors.toList()));
    }

    public static <T, R> Mono<List<R>> getWithPartitionTx(List<T> ids, YdbTxSession ts,
                                                          BiFunction<YdbTxSession, List<T>, Mono<List<R>>> mapper) {
        return getWithPartitionTx(ids, ts, mapper, DEFAULT_PARTITION_SIZE);
    }

    public static <T, R> Mono<List<R>> getWithPartitionTx(List<T> ids, YdbTxSession ts,
                                                          BiFunction<YdbTxSession, List<T>, Mono<List<R>>> mapper,
                                                          int size) {
        return Flux.fromIterable(Lists.partition(ids, size)).concatMap(idsP -> mapper.apply(ts, idsP)).collectList()
                .map(l -> l.stream().flatMap(Collection::stream).collect(Collectors.toList()));
    }
}
