package ru.yandex.intranet.d.util.bucket

import ru.yandex.monlib.metrics.labels.Labels
import ru.yandex.monlib.metrics.registry.MetricRegistry

class RateLimiter(
    val configuration: BucketConfiguration,
    val key: String
) {
    private val bucket: Bucket = Bucket(configuration) { System.nanoTime() }
    private val dropRate = MetricRegistry.root().rate("limiters.bucket.drop_rate", Labels.of("bucket", key))

    fun tryConsume(): Boolean {
        val result = bucket.tryConsume(1)
        if (!result) {
            dropRate.inc()
        }
        return result
    }

    fun getAvailable(): Long {
        return bucket.getAvailableTokens()
    }

}
