package ru.yandex.intranet.d.util.bucket

import org.springframework.stereotype.Component
import ru.yandex.monlib.metrics.labels.Labels
import ru.yandex.monlib.metrics.registry.MetricRegistry
import javax.annotation.PostConstruct

@Component
class RateLimiterMetrics(
    private val rateLimiters: List<RateLimiter>
) {

    @PostConstruct
    fun postConstruct() {
        val rootRegistry = MetricRegistry.root()
        rateLimiters.forEach { rateLimiter ->
            rootRegistry.lazyGaugeInt64("limiters.bucket.tokens", Labels.of("bucket", rateLimiter.key)) { rateLimiter.getAvailable() }
        }
    }

}
