package ru.yandex.intranet.d.util.bucket

import org.springframework.beans.factory.annotation.Value
import org.springframework.context.annotation.Bean
import org.springframework.context.annotation.Configuration
import java.time.Duration

@Configuration
open class RateLimiters {

    @Bean("publicRestApiRateLimiter")
    open fun publicRestApi(@Value("\${limiter.api.rest.public.capacity}") rps: Long): RateLimiter {
        return RateLimiter(BucketConfiguration(listOf(Bandwidth(rps, rps,
            Refill.greedy(rps, Duration.ofSeconds(1)), "rps"))), "rest_public_api")
    }

    @Bean("publicGrpcApiRateLimiter")
    open fun publicGrpcApi(@Value("\${limiter.api.grpc.public.capacity}") rps: Long): RateLimiter {
        return RateLimiter(BucketConfiguration(listOf(Bandwidth(rps, rps,
            Refill.greedy(rps, Duration.ofSeconds(1)), "rps"))), "grpc_public_api")
    }

    @Bean("frontApiRateLimiter")
    open fun frontApi(@Value("\${limiter.api.front.capacity}") rps: Long): RateLimiter {
        return RateLimiter(BucketConfiguration(listOf(Bandwidth(rps, rps,
            Refill.greedy(rps, Duration.ofSeconds(1)), "rps"))), "front_api")
    }

}
