package ru.yandex.intranet.d.util.bucket

import java.time.Duration
import java.time.Instant

data class Refill (
    val period: Nanos,
    val tokens: Tokens,
    val refillIntervally: Boolean,
    val timeOfFirstRefill: Millis?,
    val adaptiveInitialTokens: Boolean
) {
    companion object {
        @JvmStatic
        fun greedy(tokens: Long, period: Duration): Refill {
            return Refill(
                period = period.toNanos(),
                tokens = tokens,
                refillIntervally = false,
                timeOfFirstRefill = null,
                adaptiveInitialTokens = false
            )
        }
        @JvmStatic
        fun intervally(tokens: Long, period: Duration): Refill {
            return Refill(
                period = period.toNanos(),
                tokens = tokens,
                refillIntervally = true,
                timeOfFirstRefill = null,
                adaptiveInitialTokens = false
            )
        }
        @JvmStatic
        fun intervallyAligned(tokens: Long, period: Duration, timeOfFirstRefill: Instant, adaptiveInitialTokens: Boolean): Refill {
            return Refill(
                period = period.toNanos(),
                tokens = tokens,
                refillIntervally = true,
                timeOfFirstRefill = timeOfFirstRefill.toEpochMilli(),
                adaptiveInitialTokens = adaptiveInitialTokens
            )
        }
    }
}
