package ru.yandex.intranet.d.util.paging;

import java.io.UncheckedIOException;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;

import ru.yandex.intranet.d.util.JsonReader;
import ru.yandex.intranet.d.util.JsonWriter;

/**
 * Continuation token utils.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ContinuationTokens {

    private ContinuationTokens() {
    }

    public static <T> String encode(T token, ObjectWriter writer) {
        try {
            return Base64.getUrlEncoder().encodeToString(writer.writeValueAsBytes(token));
        } catch (JsonProcessingException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> Optional<T> decode(String token, ObjectReader reader) {
        try {
            return Optional.ofNullable(reader.readValue(Base64.getUrlDecoder().decode(token)));
        } catch (Exception e) {
            return Optional.empty();
        }
    }

    public static <T> String encode(T token, JsonWriter<T> writer) {
        return Base64.getUrlEncoder().encodeToString(writer.writeValueAsBytes(token));
    }

    public static <T> Optional<T> decode(String token, JsonReader<T> reader) {
        try {
            return Optional.ofNullable(reader.readValue(Base64.getUrlDecoder().decode(token)));
        } catch (Exception e) {
            return Optional.empty();
        }
    }

    public static <M, T> Page<M> toPage(
            List<M> values, int limit, Function<M, T> tokenGetter, JsonWriter<T> continuationTokenWriter
    ) {
        return values.size() > limit ?
                Page.page(
                        values.subList(0, limit),
                        ContinuationTokens.encode(
                                tokenGetter.apply(values.get(limit - 1)),
                                continuationTokenWriter
                        )
                )
                : Page.lastPage(values);
    }
}
