package ru.yandex.intranet.d.util.paging;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * Page.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class Page<T> {

    private final List<T> items;
    private final String continuationToken;

    private Page(List<T> items, String continuationToken) {
        this.items = items;
        this.continuationToken = continuationToken;
    }

    public static <T> Page<T> page(List<T> items, String continuationToken) {
        return new Page<>(items, continuationToken);
    }

    public static <T> Page<T> lastPage(List<T> items) {
        return new Page<>(items, null);
    }

    public List<T> getItems() {
        return items;
    }

    public Optional<String> getContinuationToken() {
        return Optional.ofNullable(continuationToken);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Page<?> page = (Page<?>) o;
        return Objects.equals(items, page.items) &&
                Objects.equals(continuationToken, page.continuationToken);
    }

    @Override
    public int hashCode() {
        return Objects.hash(items, continuationToken);
    }

    @Override
    public String toString() {
        return "Page{" +
                "items=" + items +
                ", continuationToken='" + continuationToken + '\'' +
                '}';
    }
}
