package ru.yandex.intranet.d.util.paging;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Common continuation token.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 */
public final class StringContinuationToken {
    private final String id;

    @JsonCreator
    public StringContinuationToken(
            @JsonProperty("id") String id
    ) {
        this.id = id;
    }

    public String getId() {
        return id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StringContinuationToken that = (StringContinuationToken) o;
        return Objects.equals(id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }

    @Override
    public String toString() {
        return "CommonContinuationToken{" +
                "id='" + id + '\'' +
                '}';
    }
}
