package ru.yandex.intranet.d.util.response;

import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

/**
 * Response utils.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class Responses {

    private Responses() {
    }

    public static <T> ResponseEntity<T> okJson(T value) {
        return ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).body(value);
    }

    public static <T> ResponseEntity<T> noContent() {
        return ResponseEntity.noContent().build();
    }

    public static <T> ResponseEntity<T> createdJson(T value) {
        return ResponseEntity.status(HttpStatus.CREATED).contentType(MediaType.APPLICATION_JSON).body(value);
    }

    public static <T> ResponseEntity<T> acceptedJson(T value) {
        return ResponseEntity.status(HttpStatus.ACCEPTED).contentType(MediaType.APPLICATION_JSON).body(value);
    }

}
