package ru.yandex.intranet.d.util.result;

import java.util.Objects;

/**
 * Typed error.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class TypedError {

    private final String error;
    private final ErrorType type;

    private TypedError(String error, ErrorType type) {
        this.error = error;
        this.type = type;
    }

    public static TypedError invalid(String error) {
        Objects.requireNonNull(error, "Error is required.");
        return new TypedError(error, ErrorType.INVALID);
    }

    public static TypedError forbidden(String error) {
        Objects.requireNonNull(error, "Error is required.");
        return new TypedError(error, ErrorType.FORBIDDEN);
    }

    public static TypedError badRequest(String error) {
        Objects.requireNonNull(error, "Error is required.");
        return new TypedError(error, ErrorType.BAD_REQUEST);
    }

    public static TypedError notFound(String error) {
        Objects.requireNonNull(error, "Error is required.");
        return new TypedError(error, ErrorType.NOT_FOUND);
    }

    public static TypedError conflict(String error) {
        Objects.requireNonNull(error, "Error is required.");
        return new TypedError(error, ErrorType.CONFLICT);
    }

    public static TypedError versionMismatch(String error) {
        Objects.requireNonNull(error, "Error is required.");
        return new TypedError(error, ErrorType.VERSION_MISMATCH);
    }

    public static TypedError locked(String error) {
        Objects.requireNonNull(error, "Error is required.");
        return new TypedError(error, ErrorType.LOCKED);
    }

    public static TypedError tooManyRequests(String error) {
        Objects.requireNonNull(error, "Error is required.");
        return new TypedError(error, ErrorType.TOO_MANY_REQUESTS);
    }

    public static TypedError unexpected(String error) {
        Objects.requireNonNull(error, "Error is required.");
        return new TypedError(error, ErrorType.UNEXPECTED);
    }

    public static TypedError unavailable(String error) {
        Objects.requireNonNull(error, "Error is required.");
        return new TypedError(error, ErrorType.UNAVAILABLE);
    }

    public static TypedError typedError(String error, ErrorType type) {
        Objects.requireNonNull(error, "Error is required.");
        Objects.requireNonNull(type, "Type is required.");
        return new TypedError(error, type);
    }

    public String getError() {
        return error;
    }

    public ErrorType getType() {
        return type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final TypedError that = (TypedError) o;
        return Objects.equals(error, that.error) &&
                type == that.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(error, type);
    }

    @Override
    public String toString() {
        return "TypedError{" +
                "error=" + error +
                ", type=" + type +
                '}';
    }

}
