package ru.yandex.intranet.d.util.version;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.intranet.d.DApplication;
import ru.yandex.library.svnversion.VcsVersion;

/**
 * Program version configuration.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Configuration
public class VersionConfiguration {

    @Bean("service.revision")
    public String serviceRevision() {
        VcsVersion version = new VcsVersion(DApplication.class);
        int svnRevision = version.getProgramSvnRevision();
        if (svnRevision < 0) {
            String programHash = version.getProgramHash();
            if (programHash.isEmpty()) {
                return "current";
            }
            return programHash;
        }
        return String.valueOf(svnRevision);
    }

}
