package ru.yandex.intranet.d.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.intranet.d.util.ObjectMapperHolder;

/**
 * Error json configuration
 *
 * @author Denis Blokhin <denblo@yandex-team.ru>
 */
@Configuration
public class ErrorJsonConfiguration {
    @Bean("errorJsonObjectMapper")
    public ObjectMapperHolder errorJsonObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule(new Jdk8Module());
        mapper.registerModule(new JavaTimeModule());
        mapper.registerModule(new ParameterNamesModule());
        mapper.registerModule(new KotlinModule.Builder().build());
        return new ObjectMapperHolder(mapper);
    }
}
