package ru.yandex.intranet.d.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.intranet.d.util.ObjectMapperHolder;

/**
 * IDM json mapper
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 * @since 19.10.2020
 */
@Configuration
public class IdmConfiguration {

    @Bean("idmJsonObjectMapper")
    public ObjectMapperHolder idmJsonObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule(new Jdk8Module());
        mapper.registerModule(new JavaTimeModule());
        mapper.registerModule(new ParameterNamesModule());
        mapper.registerModule(new KotlinModule.Builder().build());
        return new ObjectMapperHolder(mapper);
    }

}
