package ru.yandex.intranet.d.web;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.servers.Server;
import org.springdoc.core.GroupedOpenApi;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Swagger configuration
 *
 * @author Nikita Minin <spasitel@yandex-team.ru>
 */
@Configuration
public class OpenApiConfiguration {

    @Bean
    public OpenAPI customOpenAPI(@Qualifier("service.revision") String serviceRevision) {
        //TODO add version and security settings
        return new OpenAPI()
                /*.components(new Components()
                        .addSecuritySchemes("OAuthScheme",
                                new SecurityScheme().type(SecurityScheme.Type.OAUTH2).flows(
                                        new OAuthFlows().authorizationCode(
                                                new OAuthFlow()
                                                        .authorizationUrl("https://oauth.yandex-team.ru/")
                                                        .tokenUrl("https://oauth.yandex-team.ru/")
                                                        .scopes(new Scopes().addString("dispenser", "write"))
                                        )
                                )

                        ))*/
                .addServersItem(new Server().url("/"))
                .info(new Info().title("D API").version(serviceRevision));
    }

    @Bean
    public GroupedOpenApi localOpenApi() {
        String[] paths = {"/local/**"};
        return GroupedOpenApi.builder().group("local").pathsToMatch(paths).build();
    }

    @Bean
    public GroupedOpenApi sensorsOpenApi() {
        String[] paths = {"/sensors/**"};
        return GroupedOpenApi.builder().group("sensors").pathsToMatch(paths).build();
    }

    @Bean
    public GroupedOpenApi frontOpenApi() {
        String[] paths = {"/front/**"};
        return GroupedOpenApi.builder().group("front").pathsToMatch(paths).build();
    }

    @Bean
    public GroupedOpenApi backOpenApi() {
        String[] paths = {"/api/**"};
        return GroupedOpenApi.builder().group("api").pathsToMatch(paths).build();
    }

    @Bean
    public GroupedOpenApi adminOpenApi() {
        String[] paths = {"/admin/**"};
        return GroupedOpenApi.builder().group("admin").pathsToMatch(paths).build();
    }

    @Bean
    public GroupedOpenApi rootOpenApi() {
        String[] paths = {"/ping", "/"};
        return GroupedOpenApi.builder().group("root").pathsToMatch(paths).build();
    }

}
