package ru.yandex.intranet.d.web.controllers;

import io.swagger.v3.oas.annotations.Operation;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

import ru.yandex.intranet.d.services.local.LocalService;

/**
 * Local endpoints handlers.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@RestController
@RequestMapping("/local")
public class LocalController {

    private final LocalService localService;

    public LocalController(LocalService localService) {
        this.localService = localService;
    }

    @Operation(description = "Проверка жив ли сервис")
    @NonNull
    @GetMapping("/liveness")
    public Mono<ResponseEntity<String>> getLiveness() {
        return localService.getLiveness();
    }

    @Operation(description = "Проверка готов ли сервис к работе")
    @NonNull
    @GetMapping("/readiness")
    public Mono<ResponseEntity<String>> getReadiness() {
        return localService.getReadiness(false);
    }

    @Operation(description = "Проверка работает ли планировщик")
    @NonNull
    @GetMapping("/scheduler-status")
    public Mono<ResponseEntity<String>> getSchedulerStatus() {
        return localService.getSchedulerStatus();
    }

}
