package ru.yandex.intranet.d.web.controllers;

import java.util.Map;

import io.swagger.v3.oas.annotations.Operation;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

import ru.yandex.intranet.d.services.local.LocalService;
import ru.yandex.intranet.d.web.security.roles.UserOrServiceRole;

/**
 * Root handler.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@RestController
@RequestMapping("/")
public class RootController {

    private final LocalService localService;

    public RootController(LocalService localService) {
        this.localService = localService;
    }

    @Operation(description = "Root action")
    @NonNull
    @UserOrServiceRole
    @GetMapping("")
    public Mono<ResponseEntity<?>> getRoot() {
        return Mono.just(ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON)
                .body(Map.of()));
    }

    @Operation(description = "Ping action")
    @NonNull
    @GetMapping("ping")
    public Mono<ResponseEntity<String>> getPing() {
        return localService.getReadiness(true);
    }

}
