package ru.yandex.intranet.d.web.controllers.admin.aggregation

import io.swagger.v3.oas.annotations.Operation
import io.swagger.v3.oas.annotations.Parameter
import io.swagger.v3.oas.annotations.responses.ApiResponse
import io.swagger.v3.oas.annotations.responses.ApiResponses
import org.springframework.http.MediaType
import org.springframework.http.ResponseEntity
import org.springframework.web.bind.annotation.PathVariable
import org.springframework.web.bind.annotation.PostMapping
import org.springframework.web.bind.annotation.RequestMapping
import org.springframework.web.bind.annotation.RestController
import reactor.core.publisher.Mono
import ru.yandex.intranet.d.services.aggregates.RefreshServiceAggregatesService
import ru.yandex.intranet.d.web.errors.Errors
import ru.yandex.intranet.d.web.security.Auth
import ru.yandex.intranet.d.web.security.roles.UserRole
import java.security.Principal
import java.time.Clock
import java.util.*

/**
 * Aggregation controller.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@UserRole
@RestController
@RequestMapping("/admin/aggregation")
open class AggregationController(
    private val refreshServiceAggregatesService: RefreshServiceAggregatesService
) {

    @Operation(summary = "Run aggregation for provider.")
    @ApiResponses(ApiResponse(responseCode = "204", description = "Aggregation was successfully completed."))
    @PostMapping(value = ["/{providerId}/_aggregate"], produces = [MediaType.APPLICATION_JSON_VALUE])
    open fun runProviderAggregation(
        @Parameter(description = "Provider id", required = true)
        @PathVariable("providerId")
        providerId: String,
        principal: Principal,
        locale: Locale
    ): Mono<ResponseEntity<*>> {
        val currentUser = Auth.details(principal)
        return refreshServiceAggregatesService.refreshProviderWithValidationMono(providerId, currentUser,
                locale, Clock.systemUTC()).map { it.match({ ResponseEntity.noContent().build() }, Errors::toResponse) }
    }
}
