package ru.yandex.intranet.d.web.controllers.admin.local;


import java.security.Principal;
import java.util.Locale;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

import ru.yandex.intranet.d.services.local.LocalService;
import ru.yandex.intranet.d.web.security.roles.UserRole;

/**
 * Admin local controller.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@UserRole
@RestController
@RequestMapping("/admin/local")
public class AdminLocalController {
    private final LocalService localService;

    public AdminLocalController(LocalService localService) {
        this.localService = localService;
    }

    @GetMapping("/_readiness")
    public Mono<ResponseEntity<?>> getAdminReadiness(Principal principal, Locale locale) {
        return localService.getAdminReadiness(principal, locale);
    }
}
