package ru.yandex.intranet.d.web.controllers.admin.retry.model;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Account create parameters.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Account creation parameters.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class AccountCreateParamsDto {

    private final String key;
    private final String displayName;
    private final String folderId;
    private final String accountId;

    @JsonCreator
    public AccountCreateParamsDto(@JsonProperty("key") String key,
                                  @JsonProperty("displayName") String displayName,
                                  @JsonProperty("folderId") String folderId,
                                  @JsonProperty("accountId") String accountId) {
        this.key = key;
        this.displayName = displayName;
        this.folderId = folderId;
        this.accountId = accountId;
    }

    @Schema(description = "Account key.")
    public Optional<String> getKey() {
        return Optional.ofNullable(key);
    }

    @Schema(description = "Account display name.")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @Schema(description = "Folder id.", required = true)
    public String getFolderId() {
        return folderId;
    }

    @Schema(description = "Account id.", required = true)
    public String getAccountId() {
        return accountId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountCreateParamsDto that = (AccountCreateParamsDto) o;
        return Objects.equals(key, that.key) &&
                Objects.equals(displayName, that.displayName) &&
                Objects.equals(folderId, that.folderId) &&
                Objects.equals(accountId, that.accountId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(key, displayName, folderId, accountId);
    }

    @Override
    public String toString() {
        return "AccountCreateParamsDto{" +
                "key='" + key + '\'' +
                ", displayName='" + displayName + '\'' +
                ", folderId='" + folderId + '\'' +
                ", accountId='" + accountId + '\'' +
                '}';
    }

}
