package ru.yandex.intranet.d.web.controllers.admin.retry.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Account rename parameters.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Account rename parameters.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class AccountRenameParamsDto {

    private final String displayName;

    @JsonCreator
    public AccountRenameParamsDto(@JsonProperty("displayName") String displayName) {
        this.displayName = displayName;
    }

    @Schema(description = "Account display name.", required = true)
    public String getDisplayName() {
        return displayName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountRenameParamsDto that = (AccountRenameParamsDto) o;
        return Objects.equals(displayName, that.displayName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(displayName);
    }

    @Override
    public String toString() {
        return "AccountRenameParamsDto{" +
                "displayName='" + displayName + '\'' +
                '}';
    }

}
