package ru.yandex.intranet.d.web.controllers.admin.retry.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Operation changes.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Operation changes.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class OperationChangesDto {

    private final String accountId;
    private final List<OperationChangesProvisionDto> updatedProvisions;
    private final List<OperationChangesProvisionDto> frozenProvisions;
    private final AccountCreateParamsDto accountCreateParams;
    private final AccountRenameParamsDto accountRenameParams;
    private final String destinationFolderId;
    private final String destinationAccountId;
    private final List<OperationChangesProvisionDto> updatedDestinationProvisions;
    private final List<OperationChangesProvisionDto> frozenDestinationProvisions;

    @JsonCreator
    @SuppressWarnings("ParameterNumber")
    public OperationChangesDto(
            @JsonProperty("accountId") String accountId,
            @JsonProperty("updatedProvisions") List<OperationChangesProvisionDto> updatedProvisions,
            @JsonProperty("frozenProvisions") List<OperationChangesProvisionDto> frozenProvisions,
            @JsonProperty("accountCreateParams") AccountCreateParamsDto accountCreateParams,
            @JsonProperty("accountRenameParams") AccountRenameParamsDto accountRenameParams,
            @JsonProperty("destinationFolderId") String destinationFolderId,
            @JsonProperty("destinationAccountId") String destinationAccountId,
            @JsonProperty("updatedDestinationProvisions")
                    List<OperationChangesProvisionDto> updatedDestinationProvisions,
            @JsonProperty("frozenDestinationProvisions")
                    List<OperationChangesProvisionDto> frozenDestinationProvisions) {
        this.accountId = accountId;
        this.updatedProvisions = updatedProvisions;
        this.frozenProvisions = frozenProvisions;
        this.accountCreateParams = accountCreateParams;
        this.accountRenameParams = accountRenameParams;
        this.destinationFolderId = destinationFolderId;
        this.destinationAccountId = destinationAccountId;
        this.updatedDestinationProvisions = updatedDestinationProvisions;
        this.frozenDestinationProvisions = frozenDestinationProvisions;
    }

    @Schema(description = "Account id.")
    public Optional<String> getAccountId() {
        return Optional.ofNullable(accountId);
    }

    @Schema(description = "Updated provisions.")
    public List<OperationChangesProvisionDto> getUpdatedProvisions() {
        return updatedProvisions;
    }

    @Schema(description = "Frozen provisions.")
    public List<OperationChangesProvisionDto> getFrozenProvisions() {
        return frozenProvisions;
    }

    @Schema(description = "Account creation parameters.")
    public Optional<AccountCreateParamsDto> getAccountCreateParams() {
        return Optional.ofNullable(accountCreateParams);
    }

    @Schema(description = "Account rename parameters.")
    public Optional<AccountRenameParamsDto> getAccountRenameParams() {
        return Optional.ofNullable(accountRenameParams);
    }

    @Schema(description = "Destination folder id.")
    public Optional<String> getDestinationFolderId() {
        return Optional.ofNullable(destinationFolderId);
    }

    @Schema(description = "Destination account id.")
    public Optional<String> getDestinationAccountId() {
        return Optional.ofNullable(destinationAccountId);
    }

    @Schema(description = "Updated destination provisions.")
    public List<OperationChangesProvisionDto> getUpdatedDestinationProvisions() {
        return updatedDestinationProvisions;
    }

    @Schema(description = "Frozen destination provisions.")
    public List<OperationChangesProvisionDto> getFrozenDestinationProvisions() {
        return frozenDestinationProvisions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OperationChangesDto that = (OperationChangesDto) o;
        return Objects.equals(accountId, that.accountId) &&
                Objects.equals(updatedProvisions, that.updatedProvisions) &&
                Objects.equals(frozenProvisions, that.frozenProvisions) &&
                Objects.equals(accountCreateParams, that.accountCreateParams) &&
                Objects.equals(accountRenameParams, that.accountRenameParams) &&
                Objects.equals(destinationFolderId, that.destinationFolderId) &&
                Objects.equals(destinationAccountId, that.destinationAccountId) &&
                Objects.equals(updatedDestinationProvisions, that.updatedDestinationProvisions) &&
                Objects.equals(frozenDestinationProvisions, that.frozenDestinationProvisions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountId, updatedProvisions, frozenProvisions, accountCreateParams, accountRenameParams,
                destinationFolderId, destinationAccountId, updatedDestinationProvisions, frozenDestinationProvisions);
    }

    @Override
    public String toString() {
        return "OperationChangesDto{" +
                "accountId='" + accountId + '\'' +
                ", updatedProvisions=" + updatedProvisions +
                ", frozenProvisions=" + frozenProvisions +
                ", accountCreateParams=" + accountCreateParams +
                ", accountRenameParams=" + accountRenameParams +
                ", destinationFolderId='" + destinationFolderId + '\'' +
                ", destinationAccountId='" + destinationAccountId + '\'' +
                ", updatedDestinationProvisions=" + updatedDestinationProvisions +
                ", frozenDestinationProvisions=" + frozenDestinationProvisions +
                '}';
    }

}
