package ru.yandex.intranet.d.web.controllers.admin.retry.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Operation changes provision.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Provided amount of a resource.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class OperationChangesProvisionDto {

    private final String resourceId;
    private final long amount;

    @JsonCreator
    public OperationChangesProvisionDto(@JsonProperty("resourceId") String resourceId,
                                        @JsonProperty("amount") long amount) {
        this.resourceId = resourceId;
        this.amount = amount;
    }

    @Schema(description = "Resource id.", required = true)
    public String getResourceId() {
        return resourceId;
    }

    @Schema(description = "Amount in base units.", required = true)
    public long getAmount() {
        return amount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OperationChangesProvisionDto that = (OperationChangesProvisionDto) o;
        return amount == that.amount &&
                Objects.equals(resourceId, that.resourceId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceId, amount);
    }

    @Override
    public String toString() {
        return "OperationChangesProvisionDto{" +
                "resourceId='" + resourceId + '\'' +
                ", amount=" + amount +
                '}';
    }

}
