package ru.yandex.intranet.d.web.controllers.admin.retry.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Operation.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Operation.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class OperationDto {

    private final String operationId;
    private final String lastRequestId;
    private final Instant createDateTime;
    private final OperationSourceDto operationSource;
    private final OperationTypeDto operationType;
    private final String authorUserId;
    private final String authorUserUid;
    private final String providerId;
    private final String accountsSpaceId;
    private final Instant updateDateTime;
    private final RequestStatusDto requestStatus;
    private final String errorMessage;
    private final OperationChangesDto requestedChanges;
    private final OperationOrdersDto orders;

    @JsonCreator
    @SuppressWarnings("ParameterNumber")
    public OperationDto(
            @JsonProperty("operationId") String operationId,
            @JsonProperty("lastRequestId") String lastRequestId,
            @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone = "UTC")
            @JsonProperty("createDateTime") Instant createDateTime,
            @JsonProperty("operationSource") OperationSourceDto operationSource,
            @JsonProperty("operationType") OperationTypeDto operationType,
            @JsonProperty("authorUserId") String authorUserId,
            @JsonProperty("authorUserUid") String authorUserUid,
            @JsonProperty("providerId") String providerId,
            @JsonProperty("accountsSpaceId") String accountsSpaceId,
            @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone = "UTC")
            @JsonProperty("updateDateTime") Instant updateDateTime,
            @JsonProperty("requestStatus") RequestStatusDto requestStatus,
            @JsonProperty("errorMessage") String errorMessage,
            @JsonProperty("requestedChanges") OperationChangesDto requestedChanges,
            @JsonProperty("orders") OperationOrdersDto orders) {
        this.operationId = operationId;
        this.lastRequestId = lastRequestId;
        this.createDateTime = createDateTime;
        this.operationSource = operationSource;
        this.operationType = operationType;
        this.authorUserId = authorUserId;
        this.authorUserUid = authorUserUid;
        this.providerId = providerId;
        this.accountsSpaceId = accountsSpaceId;
        this.updateDateTime = updateDateTime;
        this.requestStatus = requestStatus;
        this.errorMessage = errorMessage;
        this.requestedChanges = requestedChanges;
        this.orders = orders;
    }

    @Schema(description = "Id.", required = true)
    public String getOperationId() {
        return operationId;
    }

    @Schema(description = "Last request id.")
    public Optional<String> getLastRequestId() {
        return Optional.ofNullable(lastRequestId);
    }

    @Schema(description = "Created at.", required = true)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone = "UTC")
    public Instant getCreateDateTime() {
        return createDateTime;
    }

    @Schema(description = "Source.", required = true)
    public OperationSourceDto getOperationSource() {
        return operationSource;
    }

    @Schema(description = "Type.", required = true)
    public OperationTypeDto getOperationType() {
        return operationType;
    }

    @Schema(description = "Author id.")
    public Optional<String> getAuthorUserId() {
        return Optional.ofNullable(authorUserId);
    }

    @Schema(description = "Author uid.", required = true)
    public String getAuthorUserUid() {
        return authorUserUid;
    }

    @Schema(description = "Provider id.", required = true)
    public String getProviderId() {
        return providerId;
    }

    @Schema(description = "Accounts space id.")
    public Optional<String> getAccountsSpaceId() {
        return Optional.ofNullable(accountsSpaceId);
    }

    @Schema(description = "Updated at.")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone = "UTC")
    public Optional<Instant> getUpdateDateTime() {
        return Optional.ofNullable(updateDateTime);
    }

    @Schema(description = "Status.")
    public Optional<RequestStatusDto> getRequestStatus() {
        return Optional.ofNullable(requestStatus);
    }

    @Schema(description = "Error message.")
    public Optional<String> getErrorMessage() {
        return Optional.ofNullable(errorMessage);
    }

    @Schema(description = "Requested changes.", required = true)
    public OperationChangesDto getRequestedChanges() {
        return requestedChanges;
    }

    @Schema(description = "Order values.", required = true)
    public OperationOrdersDto getOrders() {
        return orders;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OperationDto that = (OperationDto) o;
        return Objects.equals(operationId, that.operationId) &&
                Objects.equals(lastRequestId, that.lastRequestId) &&
                Objects.equals(createDateTime, that.createDateTime) &&
                operationSource == that.operationSource &&
                operationType == that.operationType &&
                Objects.equals(authorUserId, that.authorUserId) &&
                Objects.equals(authorUserUid, that.authorUserUid) &&
                Objects.equals(providerId, that.providerId) &&
                Objects.equals(accountsSpaceId, that.accountsSpaceId) &&
                Objects.equals(updateDateTime, that.updateDateTime) &&
                requestStatus == that.requestStatus &&
                Objects.equals(errorMessage, that.errorMessage) &&
                Objects.equals(requestedChanges, that.requestedChanges) &&
                Objects.equals(orders, that.orders);
    }

    @Override
    public int hashCode() {
        return Objects.hash(operationId, lastRequestId, createDateTime, operationSource, operationType, authorUserId,
                authorUserUid, providerId, accountsSpaceId, updateDateTime, requestStatus, errorMessage,
                requestedChanges, orders);
    }

    @Override
    public String toString() {
        return "OperationDto{" +
                "operationId='" + operationId + '\'' +
                ", lastRequestId='" + lastRequestId + '\'' +
                ", createDateTime=" + createDateTime +
                ", operationSource=" + operationSource +
                ", operationType=" + operationType +
                ", authorUserId='" + authorUserId + '\'' +
                ", authorUserUid='" + authorUserUid + '\'' +
                ", providerId='" + providerId + '\'' +
                ", accountsSpaceId='" + accountsSpaceId + '\'' +
                ", updateDateTime=" + updateDateTime +
                ", requestStatus=" + requestStatus +
                ", errorMessage='" + errorMessage + '\'' +
                ", requestedChanges=" + requestedChanges +
                ", orders=" + orders +
                '}';
    }

}
