package ru.yandex.intranet.d.web.controllers.admin.retry.model;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Operation orders.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Operation order values.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class OperationOrdersDto {

    private final long submitOrder;
    private final Long closeOrder;
    private final Long restoreOrder;
    private final Long destinationSubmitOrder;
    private final Long destinationCloseOrder;
    private final Long destinationRestoreOrder;

    @JsonCreator
    public OperationOrdersDto(@JsonProperty("submitOrder") long submitOrder,
                              @JsonProperty("closeOrder") Long closeOrder,
                              @JsonProperty("restoreOrder") Long restoreOrder,
                              @JsonProperty("destinationSubmitOrder") Long destinationSubmitOrder,
                              @JsonProperty("destinationCloseOrder") Long destinationCloseOrder,
                              @JsonProperty("destinationRestoreOrder") Long destinationRestoreOrder) {
        this.submitOrder = submitOrder;
        this.closeOrder = closeOrder;
        this.restoreOrder = restoreOrder;
        this.destinationSubmitOrder = destinationSubmitOrder;
        this.destinationCloseOrder = destinationCloseOrder;
        this.destinationRestoreOrder = destinationRestoreOrder;
    }

    @Schema(description = "Submit order.", required = true)
    public long getSubmitOrder() {
        return submitOrder;
    }

    @Schema(description = "Close order.")
    public Optional<Long> getCloseOrder() {
        return Optional.ofNullable(closeOrder);
    }

    @Schema(description = "Restore order.")
    public Optional<Long> getRestoreOrder() {
        return Optional.ofNullable(restoreOrder);
    }

    @Schema(description = "Destination submit order.")
    public Optional<Long> getDestinationSubmitOrder() {
        return Optional.ofNullable(destinationSubmitOrder);
    }

    @Schema(description = "Destination close order.")
    public Optional<Long> getDestinationCloseOrder() {
        return Optional.ofNullable(destinationCloseOrder);
    }

    @Schema(description = "Destination restore order.")
    public Optional<Long> getDestinationRestoreOrder() {
        return Optional.ofNullable(destinationRestoreOrder);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OperationOrdersDto that = (OperationOrdersDto) o;
        return submitOrder == that.submitOrder &&
                Objects.equals(closeOrder, that.closeOrder) &&
                Objects.equals(restoreOrder, that.restoreOrder) &&
                Objects.equals(destinationSubmitOrder, that.destinationSubmitOrder) &&
                Objects.equals(destinationCloseOrder, that.destinationCloseOrder) &&
                Objects.equals(destinationRestoreOrder, that.destinationRestoreOrder);
    }

    @Override
    public int hashCode() {
        return Objects.hash(submitOrder, closeOrder, restoreOrder, destinationSubmitOrder, destinationCloseOrder,
                destinationRestoreOrder);
    }

    @Override
    public String toString() {
        return "OperationOrdersDto{" +
                "submitOrder=" + submitOrder +
                ", closeOrder=" + closeOrder +
                ", restoreOrder=" + restoreOrder +
                ", destinationSubmitOrder=" + destinationSubmitOrder +
                ", destinationCloseOrder=" + destinationCloseOrder +
                ", destinationRestoreOrder=" + destinationRestoreOrder +
                '}';
    }

}
