package ru.yandex.intranet.d.web.controllers.admin.retry.model;

import io.swagger.v3.oas.annotations.media.Schema;

import ru.yandex.intranet.d.model.accounts.OperationSource;

/**
 * Operation source.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Operation source.")
public enum OperationSourceDto {

    USER,
    PROVIDER;

    public static OperationSourceDto from(OperationSource value) {
        switch (value) {
            case USER:
                return OperationSourceDto.USER;
            case PROVIDER:
                return OperationSourceDto.PROVIDER;
            default:
                throw new IllegalArgumentException("Unexpected operation source value: " + value);
        }
    }

}
