package ru.yandex.intranet.d.web.controllers.admin.retry.model;

import io.swagger.v3.oas.annotations.media.Schema;

import ru.yandex.intranet.d.model.accounts.AccountsQuotasOperationsModel;

/**
 * Operation type.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Operation type.")
public enum OperationTypeDto {

    UPDATE_PROVISION,
    CREATE_ACCOUNT,
    CREATE_ACCOUNT_AND_PROVIDE,
    DELETE_ACCOUNT,
    RENAME_ACCOUNT,
    MOVE_ACCOUNT,
    MOVE_PROVISION,
    PUT_ACCOUNT,
    PROVIDE_RESERVE;

    public static OperationTypeDto from(AccountsQuotasOperationsModel.OperationType value) {
        switch (value) {
            case UPDATE_PROVISION:
                return OperationTypeDto.UPDATE_PROVISION;
            case CREATE_ACCOUNT:
                return OperationTypeDto.CREATE_ACCOUNT;
            case CREATE_ACCOUNT_AND_PROVIDE:
                return OperationTypeDto.CREATE_ACCOUNT_AND_PROVIDE;
            case DELETE_ACCOUNT:
                return OperationTypeDto.DELETE_ACCOUNT;
            case RENAME_ACCOUNT:
                return OperationTypeDto.RENAME_ACCOUNT;
            case MOVE_ACCOUNT:
                return OperationTypeDto.MOVE_ACCOUNT;
            case MOVE_PROVISION:
                return OperationTypeDto.MOVE_PROVISION;
            case PUT_ACCOUNT:
                return OperationTypeDto.PUT_ACCOUNT;
            case PROVIDE_RESERVE:
                return OperationTypeDto.PROVIDE_RESERVE;
            default:
                throw new IllegalArgumentException("Unexpected operation type value: " + value);
        }
    }

}
