package ru.yandex.intranet.d.web.controllers.admin.retry.model;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Operations.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Operations.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class OperationsDto {

    private final List<OperationDto> operations;

    @JsonCreator
    public OperationsDto(@JsonProperty("operations") List<OperationDto> operations) {
        this.operations = operations;
    }

    @Schema(description = "Operations.", required = true)
    public List<OperationDto> getOperations() {
        return operations;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OperationsDto that = (OperationsDto) o;
        return Objects.equals(operations, that.operations);
    }

    @Override
    public int hashCode() {
        return Objects.hash(operations);
    }

    @Override
    public String toString() {
        return "OperationsDto{" +
                "operations=" + operations +
                '}';
    }

}
