package ru.yandex.intranet.d.web.controllers.admin.retry.model;

import io.swagger.v3.oas.annotations.media.Schema;

import ru.yandex.intranet.d.model.accounts.AccountsQuotasOperationsModel;

/**
 * Request status.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Request status.")
public enum RequestStatusDto {

    WAITING,
    OK,
    ERROR;

    public static RequestStatusDto from(AccountsQuotasOperationsModel.RequestStatus value) {
        switch (value) {
            case WAITING:
                return RequestStatusDto.WAITING;
            case OK:
                return RequestStatusDto.OK;
            case ERROR:
                return RequestStatusDto.ERROR;
            default:
                throw new IllegalArgumentException("Unexpected request status value: " + value);
        }
    }

}
