package ru.yandex.intranet.d.web.controllers.admin.utils;

import java.security.Principal;
import java.util.Locale;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

import ru.yandex.intranet.d.services.quotas.QuotasMoveStatisticService;
import ru.yandex.intranet.d.util.response.Responses;
import ru.yandex.intranet.d.util.result.Result;
import ru.yandex.intranet.d.web.errors.Errors;
import ru.yandex.intranet.d.web.model.ErrorCollectionDto;
import ru.yandex.intranet.d.web.model.quotas.QuotasMoveStatisticDto;
import ru.yandex.intranet.d.web.model.quotas.QuotasMoveStatisticInputDto;
import ru.yandex.intranet.d.web.security.Auth;
import ru.yandex.intranet.d.web.security.model.YaUserDetails;
import ru.yandex.intranet.d.web.security.roles.UserRole;

/**
 * Utils for admins
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
@UserRole
@RestController
@RequestMapping("/admin")
public class AdminUtilsControllers {

    private final QuotasMoveStatisticService quotasMoveStatisticService;

    public AdminUtilsControllers(QuotasMoveStatisticService quotasMoveStatisticService) {
        this.quotasMoveStatisticService = quotasMoveStatisticService;
    }

    @Operation(summary = "Get quota movement statistics.")
    @ApiResponses({@ApiResponse(responseCode = "200", description = "Quota movement statistics.",
            content = @Content(mediaType = MediaType.APPLICATION_JSON_VALUE,
                    schema = @Schema(implementation = QuotasMoveStatisticDto.class))),
            @ApiResponse(responseCode = "404", description = "'Service not found' error response.",
                    content = @Content(mediaType = MediaType.APPLICATION_JSON_VALUE,
                            schema = @Schema(implementation = ErrorCollectionDto.class)))})
    @PutMapping(value = "/quotaMovementStatistic", produces = MediaType.APPLICATION_JSON_VALUE)
    public Mono<ResponseEntity<?>> quotaMovementStatistic(
            @Parameter(description = "Quotas move statistic request", required = true)
            @RequestBody QuotasMoveStatisticInputDto quotasMoveStatisticInputDto,
            Principal principal, Locale locale) {
        YaUserDetails currentUser = Auth.details(principal);
        Mono<Result<QuotasMoveStatisticDto>> result = quotasMoveStatisticService
                .getQuotasMoveStatisticDto(quotasMoveStatisticInputDto.getDateFrom(),
                        quotasMoveStatisticInputDto.getDateTo(),
                        quotasMoveStatisticInputDto.getParentServiceIds(),
                        currentUser, locale);
        return result.map(r -> r.match(Responses::okJson, Errors::toResponse));
    }
}
