package ru.yandex.intranet.d.web.controllers.legacy.dto

import java.text.DecimalFormat

data class DiAmount(
    val value: Long,
    val unit: DiUnit?,
    val humanized: Humanized = Humanized(
        value.toDouble(),
        STRING_FORMAT.format(value.toDouble()),
        unit?.name,
        unit?.abbreviation
    )
) {
    data class Humanized(
        val doubleValue: Double,
        val stringValue: String,
        val unit: String?,
        val abbreviation: String?,
    )

    private companion object {
        val STRING_FORMAT = DecimalFormat("#.##")
    }
}
