package ru.yandex.intranet.d.web.controllers.legacy.dto

import ru.yandex.intranet.d.web.controllers.legacy.dto.DiUnit.Ensemble.Companion.ensembleByUnit
import java.util.*
import kotlin.math.max

/**
 * ATTENTION: changes in this enum can break clients!
 *
 *
 * User: amosov-f
 * Date: 12.05.16
 * Time: 19:45
 */
enum class DiUnit(val abbreviation: String, val dUnitKey: String? = null) {
    BPS("Bps"),
    KBPS("kBps"),
    MBPS("MBps"),
    GBPS("GBps"),
    TBPS("TBps"),
    BINARY_BPS("Bps"),
    KIBPS("KiBps"),
    MIBPS("MiBps"),
    GIBPS("GiBps"),
    TIBPS("TiBps"),
    MPS("Mps"),
    KMPS("kMps"),
    MMPS("MMps"),
    GMPS("GMps"),

    @Deprecated("")
    CURRENCY("валюты"),
    BYTE("B", "bytes"),
    KIBIBYTE("KiB", "kibibytes"),
    MEBIBYTE("MiB", "mebibytes"),
    GIBIBYTE("GiB", "gibibytes"),
    TEBIBYTE("TiB", "tebibytes"),
    PERMILLE("‰"),
    PERCENT("%"),
    COUNT("units"),
    KILO("K units"),
    MEGA("M units"),
    GIGA("G units"),
    PERMILLE_CORES("‰ cores", "millicores"),
    PERCENT_CORES("% cores"),
    CORES("cores", "cores"),
    KILO_CORES("K cores"),
    MEGA_CORES("M cores"),
    GIGA_CORES("G cores"),
    RUBLES("\u20BD"),
    THOUSAND_RUBLES("K \u20BD"),
    MILLION_RUBLES("M \u20BD"),
    GIBIBYTE_BASE("GiB"),
    TEBIBYTE_BASE("TiB"),
    PEBIBYTE_BASE("PiB"),
    EXBIBYTE_BASE("EiB");

    fun convert(amount: DiAmount): Long {
        return convert(amount.value, amount.unit!!)
    }

    fun convert(sourceValue: Long, sourceUnit: DiUnit): Long {
        return if (sourceUnit == this) sourceValue
        else ensembleByUnit(sourceUnit).convert(sourceValue, sourceUnit, this)
    }

    companion object {
        fun findByDKey(dUnitKey: String): DiUnit {
            return values().firstOrNull() { it.dUnitKey == dUnitKey }
                ?: throw NoSuchElementException("Can't find unit '$dUnitKey'.")
        }
    }

    class Ensemble private constructor(val base: Long, val key: String) {
        private val unit2deg: MutableMap<DiUnit, Int> = EnumMap(DiUnit::class.java)
        private val deg2unit: NavigableMap<Int, DiUnit> = TreeMap()
        private fun put(unit: DiUnit, deg: Int): Ensemble {
            unit2deg[unit] = deg
            deg2unit[deg] = unit
            return this
        }

        fun convert(value: Long, from: DiUnit, to: DiUnit): Long {
            val times = unit2deg[from]!! - unit2deg[to]!!
            var result = value
            for (i in 0 until times) {
                result *= base
            }
            for (i in 0 downTo times + 1) {
                result /= base
            }
            return result
        }


        fun getHumanReadableUnit(amount: DiAmount): DiUnit? {
            var deg = unit2deg[amount.unit] ?: return null
            var value: Long = amount.value
            while (value > max(base, MAX_HUMAN_READABLE)) {
                deg++
                value /= base
            }
            return Optional.ofNullable(deg2unit.ceilingEntry(deg)).orElse(deg2unit.lastEntry()).value
        }

        private fun hasUnit(unit: DiUnit): Boolean {
            return unit2deg.containsKey(unit)
        }

        fun getUnit2deg(): Map<DiUnit, Int> {
            return unit2deg
        }

        companion object {
            private const val MAX_HUMAN_READABLE: Long = 1000
            private val BYTE_ENSEMBLE = Ensemble(1024, BYTE.name)
                .put(BYTE, 0)
                .put(KIBIBYTE, 1)
                .put(MEBIBYTE, 2)
                .put(GIBIBYTE, 3)
                .put(TEBIBYTE, 4)
            private val COUNT_ENSEMBLE = Ensemble(10, COUNT.name)
                .put(PERMILLE, -3)
                .put(PERCENT, -2)
                .put(COUNT, 0)
                .put(KILO, 3)
                .put(MEGA, 6)
                .put(GIGA, 9)
            private val BPS_ENSEMBLE = Ensemble(10, BPS.name)
                .put(BPS, 0)
                .put(KBPS, 3)
                .put(MBPS, 6)
                .put(GBPS, 9)
                .put(TBPS, 12)
            private val BINARY_BPS_ENSEMBLE = Ensemble(1024, BINARY_BPS.name)
                .put(BINARY_BPS, 0)
                .put(KIBPS, 1)
                .put(MIBPS, 2)
                .put(GIBPS, 3)
                .put(TIBPS, 4)
            private val PROCESSOR_ENSEMBLE = Ensemble(10, CORES.name)
                .put(PERMILLE_CORES, -3)
                .put(PERCENT_CORES, -2)
                .put(CORES, 0)
                .put(KILO_CORES, 3)
                .put(MEGA_CORES, 6)
                .put(GIGA_CORES, 9)
            private val RUBLES_ENSEMBLE = Ensemble(10, RUBLES.name)
                .put(RUBLES, 0)
                .put(THOUSAND_RUBLES, 3)
                .put(MILLION_RUBLES, 6)
            @Deprecated("")
            @Suppress("DEPRECATION")
            private val CURRENCY_ENSEMBLE = Ensemble(10, CURRENCY.name)
                .put(CURRENCY, 0)
            private val MPS_ENSEMBLE = Ensemble(10, MPS.name)
                .put(MPS, 0)
                .put(KMPS, 3)
                .put(MMPS, 6)
                .put(GMPS, 9)
            private val GIBIBYTE_BASE_ENSEMBLE = Ensemble(1024, GIBIBYTE_BASE.name)
                .put(GIBIBYTE_BASE, 3)
                .put(TEBIBYTE_BASE, 4)
                .put(PEBIBYTE_BASE, 5)
                .put(EXBIBYTE_BASE, 6)

            @Suppress("DEPRECATION")
            val VALUES: Array<Ensemble> = arrayOf(
                BYTE_ENSEMBLE,
                COUNT_ENSEMBLE,
                BPS_ENSEMBLE,
                BINARY_BPS_ENSEMBLE,
                PROCESSOR_ENSEMBLE,
                RUBLES_ENSEMBLE,
                CURRENCY_ENSEMBLE,
                MPS_ENSEMBLE,
                GIBIBYTE_BASE_ENSEMBLE
            )

            fun ensembleByUnit(unit: DiUnit): Ensemble {
                return VALUES.first { it.hasUnit(unit) }
            }
        }
    }
}
