package ru.yandex.intranet.d.web.errors

import ru.yandex.intranet.d.web.model.ValidationMessageDto
import ru.yandex.intranet.d.web.model.ValidationMessageLevelDto.ERROR
import ru.yandex.intranet.d.web.model.ValidationMessageLevelDto.INFO
import ru.yandex.intranet.d.web.model.ValidationMessageLevelDto.WARNING
import ru.yandex.intranet.d.web.model.ValidationMessagesDto

/**
 * ValidationMessages.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 02-12-2021
 */
class ValidationMessages {
    private val fieldMessages: MutableMap<String, MutableSet<ValidationMessageDto>> = HashMap()

    fun addInfo(fieldName: String, message: String): ValidationMessages {
        fieldMessages
            .computeIfAbsent(fieldName) { HashSet() }
            .add(ValidationMessageDto(INFO, message))
        return this
    }

    fun addWarning(fieldName: String, message: String): ValidationMessages {
        fieldMessages
            .computeIfAbsent(fieldName) { HashSet() }
            .add(ValidationMessageDto(WARNING, message))
        return this
    }

    fun addError(fieldName: String, message: String): ValidationMessages {
        fieldMessages
            .computeIfAbsent(fieldName) { HashSet() }
            .add(ValidationMessageDto(ERROR, message))
        return this
    }

    fun isNotEmpty(): Boolean = fieldMessages.isNotEmpty()

    fun toDto(): ValidationMessagesDto = ValidationMessagesDto(fieldMessages)
}
