package ru.yandex.intranet.d.web.jackson;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;

import ru.yandex.intranet.d.web.model.PatchedValue;

/**
 * Deserializer from Json to PatchedValue
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */

public class PatchedValueJsonDeserializer extends JsonDeserializer<PatchedValue<?>> implements ContextualDeserializer {
    private final ObjectMapper objectMapper;
    private JavaType valueType;

    public PatchedValueJsonDeserializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        JavaType patchType = property.getType();
        JavaType type = patchType.containedType(0);
        PatchedValueJsonDeserializer deserializer = new PatchedValueJsonDeserializer(objectMapper);
        deserializer.valueType = type;
        return deserializer;
    }

    @Override
    public PatchedValue<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = jp.getCodec().readTree(jp);
        if (node.isNull()) {
            return new PatchedValue<>(null);
        } else {
            return new PatchedValue<>(objectMapper.convertValue(node, valueType));
        }
    }
}
