package ru.yandex.intranet.d.web.log;

import java.util.Optional;
import java.util.UUID;

import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;

import ru.yandex.intranet.d.web.security.model.YaAuthenticationToken;
import ru.yandex.intranet.d.web.security.model.YaPrincipal;
import ru.yandex.intranet.d.web.security.model.YaUserDetails;

/**
 * Access log attributes producer.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Component
public class AccessLogAttributesProducer {

    private static final String UID = "ru.yandex.intranet.d.uid";
    private static final String TVM_SERVICE_ID = "ru.yandex.intranet.d.tvm_service_id";
    private static final String OAUTH_CLIENT_ID = "ru.yandex.intranet.d.oauth_client_id";
    private static final String OAUTH_CLIENT_NAME = "ru.yandex.intranet.d.oauth_client_name";

    public static final String LOG_ID = "ru.yandex.intranet.d.log_id";

    public void onAuthenticationToken(ServerWebExchange exchange, YaAuthenticationToken authentication) {
        if (authentication.getPrincipal() instanceof YaPrincipal) {
            YaPrincipal principal = (YaPrincipal) authentication.getPrincipal();
            principal.getUid().ifPresent(uid -> exchange.getAttributes().put(UID, uid));
            principal.getTvmServiceId().ifPresent(id -> exchange.getAttributes().put(TVM_SERVICE_ID, id));
            principal.getOAuthClientId().ifPresent(id -> exchange.getAttributes().put(OAUTH_CLIENT_ID, id));
            principal.getOAuthClientName().ifPresent(name -> exchange.getAttributes().put(OAUTH_CLIENT_NAME, name));
        }
        if (authentication.getPrincipal() instanceof YaUserDetails) {
            YaUserDetails principal = (YaUserDetails) authentication.getPrincipal();
            principal.getUid().ifPresent(uid -> exchange.getAttributes().put(UID, uid));
            principal.getTvmServiceId().ifPresent(id -> exchange.getAttributes().put(TVM_SERVICE_ID, id));
            principal.getOAuthClientId().ifPresent(id -> exchange.getAttributes().put(OAUTH_CLIENT_ID, id));
            principal.getOAuthClientName().ifPresent(name -> exchange.getAttributes().put(OAUTH_CLIENT_NAME, name));
        }
    }

    public void addLogId(ServerWebExchange exchange) {
        exchange.getAttributes().put(LOG_ID, UUID.randomUUID().toString());
    }

    public Optional<String> getUid(ServerWebExchange exchange) {
        return Optional.ofNullable(exchange.getAttribute(UID));
    }

    public Optional<Long> getTvmServiceId(ServerWebExchange exchange) {
        return Optional.ofNullable(exchange.getAttribute(TVM_SERVICE_ID));
    }

    public Optional<String> getOAuthClientId(ServerWebExchange exchange) {
        return Optional.ofNullable(exchange.getAttribute(OAUTH_CLIENT_ID));
    }

    public Optional<String> getOAuthClientName(ServerWebExchange exchange) {
        return Optional.ofNullable(exchange.getAttribute(OAUTH_CLIENT_NAME));
    }

    public String getLogId(ServerWebExchange exchange) {
        return Optional.ofNullable((String) exchange.getAttribute(LOG_ID))
                .orElseGet(() -> exchange.getRequest().getId());
    }

}
