package ru.yandex.intranet.d.web.log;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

import org.springframework.context.annotation.Configuration;
import reactor.core.publisher.Hooks;
import reactor.core.publisher.Operators;

/**
 * Setup MDC context supplier.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Configuration
public class MdcContextSupplierConfiguration {

    private static final String MDC_CONTEXT_REACTOR_KEY = MdcContextSupplierConfiguration.class.getName();

    @PostConstruct
    void contextOperatorHook() {
        Hooks.onEachOperator(MDC_CONTEXT_REACTOR_KEY,
                Operators.lift((scannable, coreSubscriber) -> new MdcContextSupplier<>(coreSubscriber))
        );
    }

    @PreDestroy
    void cleanupHook() {
        Hooks.resetOnEachOperator(MDC_CONTEXT_REACTOR_KEY);
    }

}
