package ru.yandex.intranet.d.web.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Abc service DTO
 *
 * @author Denis Blokhin <denblo@yandex-team.ru>
 */
@Schema(description = "Abc service info.")
@JsonIgnoreProperties(ignoreUnknown = true)
public class AbcServiceDto {
    private final long id;
    private final String name;

    public AbcServiceDto(@JsonProperty("id") long id,
                         @JsonProperty("name") String name) {
        this.id = id;
        this.name = name;
    }

    @Schema(description = "Service id.", required = true)
    public long getId() {
        return id;
    }

    @Schema(description = "Service name.")
    public String getName() {
        return name;
    }
}
