package ru.yandex.intranet.d.web.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Amount DTO.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 17.11.2020
 */
@Schema(description = "Amount.")
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public final class AmountDto {
    private final String readableAmount;
    private final String readableUnit;
    private final String rawAmount;
    private final String rawUnit;
    private final String forEditAmount;
    private final String forEditUnitId;
    private final String amountInMinAllowedUnit;
    private final String minAllowedUnit;

    @JsonCreator
    @SuppressWarnings("checkstyle:ParameterNumber")
    public AmountDto(
            String readableAmount,
            String readableUnit,
            String rawAmount,
            String rawUnit,
            String forEditAmount,
            String forEditUnitId,
            String amountInMinAllowedUnit,
            String minAllowedUnit) {
        this.readableAmount = readableAmount;
        this.readableUnit = readableUnit;
        this.rawAmount = rawAmount;
        this.rawUnit = rawUnit;
        this.forEditAmount = forEditAmount;
        this.forEditUnitId = forEditUnitId;
        this.amountInMinAllowedUnit = amountInMinAllowedUnit;
        this.minAllowedUnit = minAllowedUnit;
    }

    public AmountDto(
            String readableAmount,
            String readableUnit,
            String rawAmount,
            String rawUnit
    ) {
        this.readableAmount = readableAmount;
        this.readableUnit = readableUnit;
        this.rawAmount = rawAmount;
        this.rawUnit = rawUnit;
        this.forEditAmount = null;
        this.forEditUnitId = null;
        this.amountInMinAllowedUnit = null;
        this.minAllowedUnit = null;
    }

    @Schema(description = "Quota amount in comfortable to read unit.", required = true)
    public String getReadableAmount() {
        return readableAmount;
    }

    @Schema(description = "Unit short name for readable amount.", required = true)
    public String getReadableUnit() {
        return readableUnit;
    }

    @Schema(description = "Quota amount in basic unit for calculations.", required = true)
    public String getRawAmount() {
        return rawAmount;
    }

    @Schema(description = "Unit short name for raw amount.", required = true)
    public String getRawUnit() {
        return rawUnit;
    }

    @Schema(description = "Quota amount in maximum by still integer unit for edit fields presets.", required = true)
    public String getForEditAmount() {
        return forEditAmount;
    }

    @Schema(description = "Unit ID for amount for edit.", required = true)
    public String getForEditUnitId() {
        return forEditUnitId;
    }

    @Schema(description = "Quota amount in minimum allowed unit.", required = true)
    public String getAmountInMinAllowedUnit() {
        return amountInMinAllowedUnit;
    }

    @Schema(description = "Minimum allowed Unit ID.", required = true)
    public String getMinAllowedUnit() {
        return minAllowedUnit;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AmountDto amountDto = (AmountDto) o;
        return Objects.equals(readableAmount, amountDto.readableAmount) &&
                Objects.equals(readableUnit, amountDto.readableUnit) &&
                Objects.equals(rawAmount, amountDto.rawAmount) &&
                Objects.equals(rawUnit, amountDto.rawUnit) &&
                Objects.equals(forEditAmount, amountDto.forEditAmount) &&
                Objects.equals(forEditUnitId, amountDto.forEditUnitId) &&
                Objects.equals(amountInMinAllowedUnit, amountDto.amountInMinAllowedUnit) &&
                Objects.equals(minAllowedUnit, amountDto.minAllowedUnit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(readableAmount, readableUnit, rawAmount, rawUnit, forEditAmount, forEditUnitId,
                amountInMinAllowedUnit, minAllowedUnit);
    }

    @Override
    public String toString() {
        return "AmountDto{" +
                "readableAmount='" + readableAmount + '\'' +
                ", readableUnit='" + readableUnit + '\'' +
                ", rawAmount='" + rawAmount + '\'' +
                ", rawUnit='" + rawUnit + '\'' +
                ", forEditAmount='" + forEditAmount + '\'' +
                ", forEditUnitId='" + forEditUnitId + '\'' +
                ", amountInMinAllowedUnit='" + amountInMinAllowedUnit + '\'' +
                ", minAllowedUnit='" + minAllowedUnit + '\'' +
                '}';
    }
}
