package ru.yandex.intranet.d.web.model;

import java.util.List;
import java.util.Objects;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import ru.yandex.intranet.d.web.model.folders.front.ExpandedProvider;
import ru.yandex.intranet.d.web.model.folders.front.ResourceTypeDto;
import ru.yandex.intranet.d.web.model.resources.AccountsSpaceDto;

/**
 * CreateAccountExpandedAnswerDto.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 20-09-2021
 */
public final class CreateAccountExpandedAnswerDto {
    private final ExpandedProvider expandedProvider;
    private final ProviderDto provider;
    private final List<ResourceDto> resources;
    private final List<AccountsSpaceDto> accountsSpaces;
    private final List<ResourceTypeDto> resourceTypes;

    public CreateAccountExpandedAnswerDto(
            ExpandedProvider expandedProvider,
            ProviderDto provider,
            List<ResourceDto> resources,
            List<AccountsSpaceDto> accountsSpaces,
            List<ResourceTypeDto> resourceTypes
    ) {
        this.expandedProvider = expandedProvider;
        this.provider = provider;
        this.resources = resources;
        this.accountsSpaces = accountsSpaces;
        this.resourceTypes = resourceTypes;
    }

    public ExpandedProvider getExpandedProvider() {
        return expandedProvider;
    }

    public ProviderDto getProvider() {
        return provider;
    }

    public List<ResourceDto> getResources() {
        return resources;
    }

    public List<AccountsSpaceDto> getAccountsSpaces() {
        return accountsSpaces;
    }

    public List<ResourceTypeDto> getResourceTypes() {
        return resourceTypes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateAccountExpandedAnswerDto that = (CreateAccountExpandedAnswerDto) o;
        return Objects.equals(expandedProvider, that.expandedProvider) &&
                Objects.equals(provider, that.provider) &&
                Objects.equals(resources, that.resources) &&
                Objects.equals(accountsSpaces, that.accountsSpaces) &&
                Objects.equals(resourceTypes, that.resourceTypes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(expandedProvider, provider, resources, accountsSpaces, resourceTypes);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
