package ru.yandex.intranet.d.web.model;

import java.util.Map;
import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Error info DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Request errors info.")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ErrorCollectionDto {

    private final Set<String> errors;
    private final Map<String, Set<String>> fieldErrors;
    private final Map<String, Set<Object>> details;

    @JsonCreator
    public ErrorCollectionDto(Set<String> errors,
                              Map<String, Set<String>> fieldErrors,
                              Map<String, Set<Object>> details) {
        this.errors = errors != null ? errors : Set.of();
        this.fieldErrors = fieldErrors != null ? fieldErrors : Map.of();
        this.details = details != null ? details : Map.of();
    }

    @Schema(description = "Errors list.")
    public Set<String> getErrors() {
        return errors;
    }

    @Schema(description = "Errors per field.")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Map<String, Set<String>> getFieldErrors() {
        return fieldErrors;
    }

    @Schema(description = "Error details.")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Map<String, Set<Object>> getDetails() {
        return details;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ErrorCollectionDto that = (ErrorCollectionDto) o;
        return Objects.equals(errors, that.errors) &&
                Objects.equals(fieldErrors, that.fieldErrors) &&
                Objects.equals(details, that.details);
    }

    @Override
    public int hashCode() {
        return Objects.hash(errors, fieldErrors, details);
    }

    @Override
    public String toString() {
        return "ErrorCollectionDto{" +
                "errors=" + errors +
                ", fieldErrors=" + fieldErrors +
                ", details=" + details +
                '}';
    }

}
