package ru.yandex.intranet.d.web.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Feature state DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Feature state.")
public enum FeatureStateDto {

    UNSPECIFIED,
    DISABLED,
    ENABLED;

    @JsonValue
    public String toJsonValue() {
        return name();
    }

    @JsonCreator
    public static FeatureStateDto fromJsonValue(String value) {
        return FeatureStateDto.valueOf(value);
    }

    public static FeatureStateDto fromModel(Boolean model) {
        if (model == null) {
            return FeatureStateDto.UNSPECIFIED;
        }
        if (model) {
            return FeatureStateDto.ENABLED;
        }
        return FeatureStateDto.DISABLED;
    }

}
