package ru.yandex.intranet.d.web.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Feature state input DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Feature state.")
public enum FeatureStateInputDto {

    UNKNOWN,
    UNSPECIFIED,
    DISABLED,
    ENABLED;

    private static final Logger LOG = LoggerFactory.getLogger(FeatureStateInputDto.class);

    @JsonValue
    public String toJsonValue() {
        return name();
    }

    @JsonCreator
    public static FeatureStateInputDto fromJsonValue(String value) {
        try {
            return FeatureStateInputDto.valueOf(value);
        } catch (IllegalArgumentException e) {
            LOG.warn("Unexpected FeatureStateInputDto value: " + value, e);
            return FeatureStateInputDto.UNKNOWN;
        }
    }

    public static FeatureStateInputDto fromModel(Boolean model) {
        if (model == null) {
            return FeatureStateInputDto.UNSPECIFIED;
        }
        if (model) {
            return FeatureStateInputDto.ENABLED;
        }
        return FeatureStateInputDto.DISABLED;
    }

}
