package ru.yandex.intranet.d.web.model;

import java.util.Map;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.MoreObjects;
import io.swagger.v3.oas.annotations.media.Schema;

import ru.yandex.intranet.d.web.model.quotas.UpdateProvisionDryRunAnswerDto;

/**
 * FrontProvisionsDto.
 *
 * @author Chizhikov Aleksey <achizhikov@yandex-team.tu>
 * @since 20-12-2021
 */
@Schema(description = "Updated provisions for frontend")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class FrontProvisionsDto {
    private final Map<String, UpdateProvisionDryRunAnswerDto> provisionsByResourceId;

    @JsonCreator
    public FrontProvisionsDto(
            Map<String, UpdateProvisionDryRunAnswerDto> provisionsByResourceId
    ) {
        this.provisionsByResourceId = provisionsByResourceId;
    }

    @Schema(description = "Map of new provisions by resource id.", required = true)
    public Map<String, UpdateProvisionDryRunAnswerDto> getProvisionsByResourceId() {
        return provisionsByResourceId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FrontProvisionsDto that = (FrontProvisionsDto) o;
        return Objects.equals(provisionsByResourceId, that.provisionsByResourceId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(provisionsByResourceId);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("provisionsByResourceId", provisionsByResourceId)
                .toString();
    }
}
