package ru.yandex.intranet.d.web.model

import com.fasterxml.jackson.annotation.JsonIgnore
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.backend.service.proto.MultilingualGrammaticalForms
import ru.yandex.intranet.d.model.GrammaticalCases

/**
 * GrammaticalCasesDto.
 *
 * @author Vladimir Zaytsev <vzay></vzay>@yandex-team.ru>
 * @since 09-03-2022
 */
@Schema(description = "Name in various grammatical forms.")
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
data class GrammaticalCasesDto(
    val nominative: String?,
    val genitive: String?,
    val dative: String?,
    val accusative: String?,
    val instrumental: String?,
    val prepositional: String?,
    val locative: String?,
) {
    constructor(model: GrammaticalCases) : this(
        nominative = model.nominative,
        genitive = model.genitive,
        dative = model.dative,
        accusative = model.accusative,
        instrumental = model.instrumental,
        prepositional = model.prepositional,
        locative = model.locative,
    )

    constructor(model: MultilingualGrammaticalForms.GrammaticalCases) : this(
        nominative = model.nominative,
        genitive = model.genitive,
        dative = model.dative,
        accusative = model.accusative,
        instrumental = model.instrumental,
        prepositional = model.prepositional,
        locative = model.locative
    )

    @JsonIgnore
    fun toModel(): GrammaticalCases {
        return GrammaticalCases(
            nominative = nominative,
            genitive = genitive,
            dative = dative,
            accusative = accusative,
            instrumental = instrumental,
            prepositional = prepositional,
            locative = locative
        )
    }
}
