package ru.yandex.intranet.d.web.model

import com.fasterxml.jackson.annotation.JsonIgnore
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import io.swagger.v3.oas.annotations.media.Schema
import ru.yandex.intranet.d.model.MultilingualGrammaticalForms

/**
 * MultilingualGrammaticalFormsDto.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 05-03-2022
 */
@Schema(description = "Name in various languages and grammatical forms.")
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
data class MultilingualGrammaticalFormsDto(
    val nameSingularRu: GrammaticalCasesDto?,
    val namePluralRu: GrammaticalCasesDto?,
    val nameSingularEn: String?,
    val namePluralEn: String?,
) {
    constructor(model: MultilingualGrammaticalForms) : this(
        nameSingularRu = model.nameSingularRu?.let { GrammaticalCasesDto(it) },
        namePluralRu = model.namePluralRu?.let { GrammaticalCasesDto(it) },
        nameSingularEn = model.nameSingularEn,
        namePluralEn = model.namePluralEn,
    )

    constructor(proto: ru.yandex.intranet.d.backend.service.proto.MultilingualGrammaticalForms) : this(
        nameSingularRu = proto.nameSingularRu?.let { GrammaticalCasesDto(it) },
        namePluralRu = proto.namePluralRu?.let { GrammaticalCasesDto(it) },
        nameSingularEn = proto.nameSingularEn?.value,
        namePluralEn = proto.namePluralEn?.value,
    )

    @JsonIgnore
    fun toModel(): MultilingualGrammaticalForms {
        return  MultilingualGrammaticalForms(
            nameSingularRu = nameSingularRu?.toModel(),
            namePluralRu = namePluralRu?.toModel(),
            nameSingularEn = nameSingularEn,
            namePluralEn = namePluralEn,
        )
    }
}
