package ru.yandex.intranet.d.web.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Results page DTO.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Schema(description = "Results page.")
@JsonIgnoreProperties(ignoreUnknown = true)
public class PageDto<T> {

    private final List<T> items;
    private final String nextPageToken;

    @JsonCreator
    public PageDto(@JsonProperty("items") List<T> items,
                   @JsonProperty("nextPageToken") String nextPageToken) {
        this.items = items;
        this.nextPageToken = nextPageToken;
    }

    @Schema(description = "Page items.")
    public List<T> getItems() {
        return items;
    }

    @Schema(description = "Next page token.")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<String> getNextPageToken() {
        return Optional.ofNullable(nextPageToken);
    }

    @Override
    @SuppressWarnings("EqualsGetClass")
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PageDto<?> pageDto = (PageDto<?>) o;
        return Objects.equals(items, pageDto.items) &&
                Objects.equals(nextPageToken, pageDto.nextPageToken);
    }

    @Override
    public int hashCode() {
        return Objects.hash(items, nextPageToken);
    }

    @Override
    public String toString() {
        return "PageDto{" +
                "items=" + items +
                ", nextPageToken='" + nextPageToken + '\'' +
                '}';
    }

}
