package ru.yandex.intranet.d.web.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description = "Provider resource.")
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProviderResourceDto {

    private final String id;
    private final String providerId;
    private final String description;
    private final String name;

    @JsonCreator
    public ProviderResourceDto(@JsonProperty("id") String id,
                               @JsonProperty("providerId") String providerId,
                               @JsonProperty("description") String description,
                               @JsonProperty("name") String name) {
        this.id = id;
        this.providerId = providerId;
        this.description = description;
        this.name = name;
    }

    @Schema(description = "Id.", required = true)
    public String getId() {
        return id;
    }

    @Schema(description = "Provider id.", required = true)
    public String getProviderId() {
        return providerId;
    }

    @Schema(description = "Description.", required = true)
    public String getDescription() {
        return description;
    }

    @Schema(description = "Name.", required = true)
    public String getName() {
        return name;
    }
}
