package ru.yandex.intranet.d.web.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

import ru.yandex.intranet.d.model.TenantId;
import ru.yandex.intranet.d.model.quotas.QuotaModel;

/**
 * Quota dto
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class QuotaDto {
    private final TenantId tenantId;
    private final String folderId;
    private final String providerId;
    private final String resourceId;
    private final String quota;
    private final String balance;
    private final String frozenQuota;

    @JsonCreator
    public QuotaDto(TenantId tenantId,
                    String folderId,
                    String providerId,
                    String resourceId,
                    String quota,
                    String balance,
                    String frozenQuota) {
        this.tenantId = tenantId;
        this.folderId = folderId;
        this.providerId = providerId;
        this.resourceId = resourceId;
        this.quota = quota;
        this.balance = balance;
        this.frozenQuota = frozenQuota;
    }

    public QuotaDto(QuotaModel q) {
        this.tenantId = q.getTenantId();
        this.folderId = q.getFolderId();
        this.providerId = q.getProviderId();
        this.resourceId = q.getResourceId();
        this.quota = q.getQuota() == null ? null : q.getQuota().toString();
        this.balance = q.getBalance() == null ? null : q.getBalance().toString();
        this.frozenQuota = String.valueOf(q.getFrozenQuota());
    }

    @Schema(description = "Tenant id.", required = true)
    public TenantId getTenantId() {
        return tenantId;
    }

    @Schema(description = "Folder id.", required = true)
    public String getFolderId() {
        return folderId;
    }

    @Schema(description = "Provider id.", required = true)
    public String getProviderId() {
        return providerId;
    }

    @Schema(description = "Resource id.", required = true)
    public String getResourceId() {
        return resourceId;
    }

    @Schema(description = "Quota.", required = true)
    public String getQuota() {
        return quota;
    }

    @Schema(description = "Balance.", required = true)
    public String getBalance() {
        return balance;
    }

    @Schema(description = "Frozen quota.", required = true)
    public String getFrozenQuota() {
        return frozenQuota;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        QuotaDto quotaDto = (QuotaDto) o;
        return Objects.equals(tenantId, quotaDto.tenantId) &&
                Objects.equals(folderId, quotaDto.folderId) &&
                Objects.equals(providerId, quotaDto.providerId) &&
                Objects.equals(resourceId, quotaDto.resourceId) &&
                Objects.equals(quota, quotaDto.quota) &&
                Objects.equals(balance, quotaDto.balance) &&
                Objects.equals(frozenQuota, quotaDto.frozenQuota);
    }

    @Override
    public int hashCode() {
        return Objects.hash(tenantId, folderId, providerId, resourceId, quota, balance, frozenQuota);
    }

    @Override
    public String toString() {
        return "QuotaDto{" +
                "tenantId=" + tenantId +
                ", folderId='" + folderId + '\'' +
                ", providerId='" + providerId + '\'' +
                ", resourceId='" + resourceId + '\'' +
                ", quota='" + quota + '\'' +
                ", balance='" + balance + '\'' +
                ", frozenQuota='" + frozenQuota + '\'' +
                '}';
    }
}
